unit Divers;

interface

uses
ShellApi;

type
  TStringArray = Array of String;

  function IsFloat(Expression:string):Boolean;
  function IsInteger(Expression:string):Boolean;
  function Replace(texte,what,bywhat:string):string;
  function OpenTextFile(FileName:string):string;
  function OpenTextFileA(FileName : string): TStringArray;
  function AppPath:string;
  function InStr(S, SubStr:string):integer;
  function CLeft(S:string; L:integer):string;
  function CRight(S:string; L:integer):string;
  function LTrim(S:string):string;
  function RTrim(S:String):string;
  function Trim(S:String):string;
  function Split(Expression, Separator: string): TStringArray;
  function InstrRev(S, SubStr: string): integer;
  procedure Shell(PathName: string; ShowMode:Integer);


const
  CRLF = Chr(13) + Chr(10);
  CHR_CRLF = Chr(13) + Chr(10);
  CHR_TAB = Chr(9);
  CHR_BACK = Chr(8);
  CHR_CR = Chr(13);
  CHR_LF = Chr(10);

  SW_HIDE = 0;            //Laner l'application de faon cache
  SW_SHOWNORMAL = 1;
  SW_SHOWMINIMIZED = 2;   //Lancer l'application en minimized
  SW_SHOWMAXIMIZED = 3;   //Lancer l'application an maximized
  SW_SHOWNOACTIVATE = 4;  //Laner l'application en minimized mais ne pas lui donner le focus
  SW_SHOWMINNOACTIVE = 7; //Laner l'application en minimized mais ne pas lui donner le focus
  SW_SHOWDEFAULT = 10;    //Laner l'application avec le focus et affichage normal



implementation
function IsFloat(Expression:string):Boolean;
var
n:integer;
ComaFound:Boolean;
begin
  if Expression = '' then
  begin
    Result:=False;
    Exit;
  end;
  If Copy(Expression,1,1) = '-' then Expression := Copy(Expression, 2, Length(Expression)-1);

  ComaFound:=False;
  For n:=1 to Length(Expression) do begin
    If Copy(Expression,n,1) = ',' then begin
      If comafound then begin
        Result:=False;
        Exit;
      end
      else
        ComaFound:=True;
    end
    else if Pos(Copy(Expression,n,1),'0123456789') = 0 then begin
      Result:=False;
      Exit;
    end;
  end;
  Result:=True;

end;

function IsInteger(Expression:string):Boolean;
var
n:integer;
begin
  if Expression = '' then
  begin
    Result:=False;
    Exit;
  end;
  If Copy(Expression,1,1) = '-' then Expression := Copy(Expression, 2, Length(Expression)-1);
  For n:=1 to Length(Expression) do begin
    if Pos(Copy(Expression,n,1),'0123456789') = 0 then begin
      Result:=False;
      Exit;
    end;
  end;
  Result:=True;

end;

function Replace(texte,what,bywhat:string):string;
begin
  //if Pos(what,texte) = 0 then Result := Texte;
  Result := '';
  while Pos(what,texte) <> 0 do begin
    Result := Copy(texte, 1, Pos(what, texte)-1) + bywhat;
    texte:= Copy(texte,Pos(what,texte) + Length(what),Length(texte));

  end;
  Result := Result + texte;
end;

function OpenTextFile(FileName:string):string;
var
F:TextFile;
S:String;
begin
  AssignFile(F,FileName);
  Reset(F);
  While not EOF(F) do begin
    ReadLn(F,S);
    Result := Result + S + CRLF;

  end;
  CloseFile(F);

end;

function OpenTextFileA(FileName : string): TStringArray;
var
F:TextFile;
S:String;
begin
  AssignFile(F,FileName);
  Reset(F);
  While not EOF(F) do begin
    ReadLn(F,S);
    SetLength(Result, Length(Result) + 1);
    Result[Length(Result)-1] := S;

  end;
  CloseFile(F);

end;

function AppPath:string;
var
n:integer;
S:String;
begin
  S := ParamStr(0);
  n := Pos('\', S);
  While n <> 0 do begin
    Result := Result + Copy(S, 1, n);
    S := Copy(S, n + 1, Length(S) - n);
    n := Pos('\', S);
  end;
end;

function InStr(S, SubStr:string):integer;
begin
  Result := Pos(SubStr,S);

end;

function CLeft(S:string; L:integer):string;
begin
  Result := Copy(S, 1, L);
end;

function CRight(S:string; L:integer):string;
begin
  Result := Copy(S, Length(S) - L + 1, L);

end;

function LTrim(S:string):string;
begin
  While Copy(S, 1, 1) = ' ' do
    S := Copy(S, 2, Length(S) - 1);
  Result := S;

end;

function RTrim(S:String):string;
begin
  While Copy(S, Length(S), 1) = ' ' do
    S := Copy(S, 1, Length(S) -1);
  Result := S;

end;

function Trim(S:String):string;
begin
  While Copy(S, 1, 1) = ' ' do
    S := Copy(S, 2, Length(S) - 1);
  While Copy(S, Length(S), 1) = ' ' do
    S := Copy(S, 1, Length(S) -1);
  Result := S;

end;

function Split(Expression, Separator: string): TStringArray;
var
LenSep,n:integer;
begin
  SetLength(Result, 1);
  LenSep := Length(Separator);
  n := Pos(Separator, Expression);
  While n <> 0 do begin
    Result[Length(Result) - 1] := Copy(Expression, 1, n - 1);
    Expression := Copy(Expression, n + LenSep, Length(Expression) - LenSep - n +1);
    SetLength(Result, Length(Result) +1);
    n := Pos(Separator, Expression);
  end;
  Result[Length(Result) - 1] := Expression;

end;

procedure Shell(PathName: string; ShowMode:Integer);
begin
  ShellExecute(0,'open', PChar(PathName), '', '', ShowMode);

end;

function InstrRev(S, SubStr: string): integer;
var
n:integer;
begin
  n := pos(SubStr, S);
  result := 0;
  while n <> 0 do begin
    result := result + n;
    S := Copy(S, n + 1, Length(S) - n);
    n := pos(SubStr, S);
  end;
end;


end.
